/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.ventas;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Compensacion
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<Compensacion>,
Exportable,
Importable {
    private static final long serialVersionUID = -3745730307722378182L;
    private String codigo;
    private String descripcionCompensacion;
    private String monto;
    private BigDecimal porcentajeCompensacion;

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tipoCompe");
        Element eValor = (Element)valorList.item(0);
        this.setCodigo(eValor.getTextContent().trim());
        this.descripcionCompensacion = DataCatalogos.obtenerNombreDetalleCatalogo((String)"COMPENSACIONES", (String)this.getCodigo());
        valorList = elemento.getElementsByTagName("monto");
        eValor = (Element)valorList.item(0);
        this.setMonto(eValor.getTextContent().trim());
        this.porcentajeCompensacion = UtilCatalogosATS.crearInstancia().obtenerPorcentajeCompensacion(this.getCodigo());
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element compensacion = documento.createElement("compensacion");
        Element tipo = documento.createElement("tipoCompe");
        tipo.setTextContent(this.getCodigo());
        compensacion.appendChild(tipo);
        Element monto = documento.createElement("monto");
        monto.setTextContent(this.getMonto());
        compensacion.appendChild(monto);
        return compensacion;
    }

    public Compensacion crearCopiaEdicion() {
        return null;
    }

    public void actualizarInformacion(Compensacion copiaEdicion) {
    }

    protected ResultadoValidacion validarObjeto() {
        return null;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getMonto() {
        return this.monto;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Compensacion other = (Compensacion)((Object)obj);
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public void setMonto(String monto) {
        String oldValue = this.monto;
        this.monto = monto;
        this.firePropertyChange("monto", oldValue, this.monto);
    }

    public String getDescripcionCompensacion() {
        return this.descripcionCompensacion;
    }

    public void setDescripcionCompensacion(String descripcionCompensacion) {
        this.descripcionCompensacion = descripcionCompensacion;
    }

    public BigDecimal getPorcentajeCompensacion() {
        return this.porcentajeCompensacion;
    }

    public void setPorcentajeCompensacion(BigDecimal porcentajeCompensacion) {
        this.porcentajeCompensacion = porcentajeCompensacion;
    }
}

